#### Solutions to Practice with Turtle Graphics ####

import turtle #required for all of the solutions below

wn = turtle.Screen() #we will draw everything in one window, with one turtle
t = turtle.Turtle()


# Problem 1: square with blue border and orange interior
t.color("blue")
t.fillcolor("orange")
t.begin_fill()
for i in range(4):
    t.forward(50)
    t.left(90)
t.end_fill()


t.penup()	#move the turtle to a new location for the next solution
t.forward(100)
t.pendown()


# Problem 2: square with dots at its corners
t.fillcolor("blue")
t.shape("circle")
for i in range(4):
    t.forward(50)
    t.left(90)
    t.stamp()


t.right(90)   #move the turtle to a new location for the next solution
t.penup()
t.forward(100)
t.pendown()


# Problem 3: square of user-specified size and color
length = int(input("Enter a side length: "))
color = input("Enter a color: ")

t.color(color)
for i in range(4):
    t.forward(length)
    t.left(90)


t.right(90)   #move the turtle to a new location for the next solution
t.penup()
t.forward(100)
t.pendown()


# Problem 4: regular n-gon
n = int(input("How many sides? "))
length = int(input("Enter a side length: "))

for i in range(n):
    t.forward(length)
    t.left(360/n)


wn.exitonclick() #now we can close the window
