#### Solutions to Practice with Tkinter ####

import tkinter as tk


# Problem 1: Set up a Tkinter canvas and draw a face on it
window = tk.Tk()

# create a canvas
my_canvas = tk.Canvas(window, width=300, height=200)
my_canvas.pack()

# draw a smiley face
my_canvas.create_oval(80, 80, 120, 120, width=2, fill="yellow")
my_canvas.create_oval(90, 94, 96, 100, fill="black")
my_canvas.create_oval(104, 94, 110, 100, fill="black")
my_canvas.create_arc(84, 80, 116, 112, width=2, start=210, extent=120, style=tk.ARC)

# start the GUI event loop
window.mainloop()



# Problem 2: Program a button to draw a rectangle at a random position in a Tkinter canvas.
import random

# Create the application window
window = tk.Tk()
window.title("Random Rectangles")

# Create a canvas
w = 500
h = 300
my_canvas = tk.Canvas(window, width=w, height=h)
my_canvas.pack()

# Set up a button to draw on a canvas
def draw_rect():
	a = random.randrange(w-100)
	b = random.randrange(h-100)
	c = random.randrange(100)
	d = random.randrange(100)
	my_canvas.create_rectangle(a, b, a+c, b+d,fill="blue")

draw_button = tk.Button(window, text="Draw a rectangle")
draw_button.pack()
draw_button['command'] = draw_rect

# Start the GUI event loop
window.mainloop()



# Problem 3: Program a button to update the text in a label

# Create the application window
window = tk.Tk()
window.title("Random Rectangles")

# create a label
mylabel = tk.Label(window, text="sample label")
mylabel.pack()

# function that changes the label text
def updateLabel():
	mylabel['text'] = "updated text"
    
# create a button
mybutton = tk.Button(window, text="Update the label text")
mybutton.pack()
mybutton['command'] = updateLabel

# start the GUI event loop
window.mainloop()