#### Solutions to Practice with Exceptions ####


# Problem 1: handle a possible IndexError
def printListElement(thelist, index):
	try: 
		print(thelist[index])
	except IndexError:
		print("Sorry, the requested index,",index, "was not found in the list.")

#testing
alist = ["a","b"]
printListElement(alist, 1)
printListElement(alist, 4)



# Problem 2: handle a ValueError
try:
	n = int(input("Enter an integer: "))
except ValueError:
	print("Sorry, you did not enter an integer.")



# Problem 3: modify the previous program to continue asking for another integer if the user doesn't enter an integer
valid = False
n = 0

while not valid:
	try:
		n = int(input("Enter an integer: "))
		valid = True
		print("good:",valid)

	except ValueError:
		print("Sorry, you did not enter an integer. Please try again.")



# Problem 4: attempt to open a file and handle a possible FileNotFoundError 
filename = input("Enter a filename: ")

try:
	F = open(filename, "r")
	for line in F:
		print(line)
	F.close()
except FileNotFoundError:
	print("Error: File not found!")